/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.client;

import com.filenet.api.collection.GroupSet;
import com.filenet.api.collection.RealmSet;
import com.filenet.api.collection.UserSet;
import com.filenet.api.constants.FilteredPropertyType;
import com.filenet.api.constants.PrincipalSearchAttribute;
import com.filenet.api.constants.PrincipalSearchSortType;
import com.filenet.api.constants.PrincipalSearchType;
import com.filenet.api.core.Connection;
import com.filenet.api.core.EntireNetwork;
import com.filenet.api.core.Factory;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.security.Group;
import com.filenet.api.security.Realm;
import com.filenet.api.security.User;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.util.J2EEUtil;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Locale;
import javax.security.auth.Subject;

public class ORBFetchMemberOf
implements PrivilegedExceptionAction {
    static final String m_className = "ORBFetchMemberOf";
    protected static Logger logger = Logger.getLogger("filenet.pe.peorb.client");
    private static final long serialVersionUID = 464L;
    private static PropertyFilter pf = null;
    private String m_cempURI = null;
    private String m_userName = null;
    private Subject m_subject = null;

    public static String _get_FILE_DATE() {
        return "$Date:   06 Jul 2008 11:01:00  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.1  $";
    }

    public ORBFetchMemberOf(String paramCEMPURL, String paramUserName) throws VWException {
        this.m_cempURI = paramCEMPURL;
        this.m_userName = paramUserName;
    }

    protected void setSubject(Subject mySubject) {
        this.m_subject = mySubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object runEx() throws VWException {
        Object object;
        if (this.m_cempURI != null && this.m_cempURI.equals("/FileNet/Local/Engine")) {
            return J2EEUtil.getInstance().doAs(this.m_subject, (PrivilegedExceptionAction)this);
        }
        UserContext old = UserContext.get();
        try {
            UserContext uc = new UserContext();
            uc.pushSubject(this.m_subject);
            UserContext.set((UserContext)uc);
            object = this.run();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            UserContext.set((UserContext)old);
            throw throwable;
        }
        UserContext.set((UserContext)old);
        return object;
    }

    public Object run() throws VWException {
        String m_method = "run";
        String[] results = new String[]{""};
        logger.entering(m_className, "run");
        if (logger.isFinest()) {
            logger.finest(m_className, "run", "What groups is " + this.m_userName + " a member of?");
        }
        Connection myConnection = Factory.Connection.getConnection((String)this.m_cempURI);
        EntireNetwork entireNetwork = Factory.EntireNetwork.fetchInstance((Connection)myConnection, null);
        RealmSet allRealms = entireNetwork.get_AllRealms();
        for (Realm realm : allRealms) {
            if (logger.isFinest()) {
                logger.finest(m_className, "run", "looking at realm " + realm.get_Name());
            }
            UserSet theUsers = realm.findUsers(this.m_userName, PrincipalSearchType.EXACT, PrincipalSearchAttribute.SHORT_NAME, PrincipalSearchSortType.ASCENDING, new Integer(0), pf);
            for (User user : theUsers) {
                if (!user.get_ShortName().toUpperCase(Locale.ENGLISH).equals(this.m_userName.toUpperCase(Locale.ENGLISH))) continue;
                if (logger.isFinest()) {
                    logger.finest(m_className, "run", "found " + this.m_userName + " in realm " + realm.get_Name());
                }
                GroupSet myGroups = user.get_MemberOfGroups();
                Iterator groupIter = myGroups.iterator();
                Group group2 = null;
                int limit = 0;
                while (groupIter.hasNext()) {
                    group2 = (Group)groupIter.next();
                    ++limit;
                }
                results = new String[limit];
                int i = 0;
                for (Group group2 : myGroups) {
                    results[i] = group2.get_ShortName();
                    if (logger.isFinest()) {
                        logger.finest(m_className, "run", this.m_userName + "is a member of " + results[i]);
                    }
                    ++i;
                }
                logger.exiting(m_className, "run");
                return results;
            }
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "run", "User " + this.m_userName + " was not found");
        }
        logger.exiting(m_className, "run");
        return results;
    }

    static {
        pf = new PropertyFilter();
        pf.addIncludeType(1, null, null, FilteredPropertyType.ANY);
        pf.addExcludeProperty("ClassDescriptions");
    }
}

